-- LEAVE_CANCELLED_RECIPIENT

set sql_safe_updates=0;

SET @leaveDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_CANCELLED_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T5.salutationName AS SALUTATION_NAME,
    T2.comment AS REASON,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    T6.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(T1.cancelFrom, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.cancelTo, '%d-%m-%Y') AS TO_DATE
FROM
    hr_emp_leave_request AS T1
        LEFT JOIN
    hr_emp_leave_request_detail AS T2 ON T2.empLeaveRequestId = T1.id
        INNER JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        INNER JOIN
    persons AS requester ON requester.id = T3.personId
        LEFT JOIN
    users AS reqUser ON reqUser.id = T3.userId
        LEFT JOIN
    staffs AS T4 ON T4.userId = T2.approverId
        LEFT JOIN
    persons AS approver ON approver.id = T4.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
WHERE
    T1.id IN (namedParams)
        AND T1.status IN ('CANCELLED' , 'PARTIALLY CANCELLED','PARTIALLYCANCELLED')
GROUP BY T1.id"
WHERE
    `dataProviderId` = @leaveDtproviderId;

set sql_safe_updates=1;

